% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/siamcat_class_accessors.R
\docType{methods}
\name{filt_params}
\alias{filt_params}
\alias{filt_params,siamcat-method}
\title{Retrieve the list of parameters for feature filtering from a
SIAMCAT object}
\usage{
filt_params(siamcat, verbose=1)

\S4method{filt_params}{siamcat}(siamcat, verbose = 1)
}
\arguments{
\item{siamcat}{(Required). An instance of \link{siamcat-class}
containing filtered features}

\item{verbose}{integer, if the slot is empty, should a message be printed?
values can be either \code{0} (no output) or \code{1} (print message)}
}
\value{
A list of feature filtering parameters or \code{NULL}
}
\description{
Function to retrieve the list of parameters for feature
filtering
}
\details{
The function returns the list of feature filtering parameters.
See \link{filter.features} for more details.
}
\examples{
data(siamcat_example)
temp <- filt_params(siamcat_example)
names(temp)
}
