% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_meta_pred.r
\encoding{UTF-8}
\name{add.meta.pred}
\alias{add.meta.pred}
\title{Add metadata as predictors}
\usage{
add.meta.pred(siamcat, pred.names, std.meta = TRUE, 
feature.type='normalized', verbose = 1)
}
\arguments{
\item{siamcat}{object of class \link{siamcat-class}}

\item{pred.names}{vector of names of the variables within the metadata to 
be added to the feature matrix as predictors}

\item{std.meta}{boolean, should added metadata features be standardized?,
defaults to \code{TRUE}}

\item{feature.type}{string, on which type of features should the function 
work? Can be either \code{"original"}, \code{"filtered"}, or 
\code{"normalized"}. Please only change this paramter if you know what
you are doing!}

\item{verbose}{integer, control output: \code{0} for no output at all, 
\code{1} for only information about progress and success, \code{2} for
normal level of information and \code{3} for full debug information,
defaults to \code{1}}
}
\value{
an object of class \link{siamcat-class} with metadata added to the
features
}
\description{
This function adds metadata to the feature matrix to be later
used as predictors
}
\details{
This functions adds one or several metadata variables to the set
of features, so that they can be included for model training.

Usually, this function should be called before \link{train.model}.

Numerical meta-variables are added as z-scores to the feature matrix unless
specified otherwise.

Please be aware, that non-numerical metadata variables will be converted to
numerical values by using \code{as.numeric()} and could therefore lead to
errors. Thus, it makes sense to encode non-numerical metadata variables to
numerically before you start the SIAMCAT workflow.
}
\examples{
data(siamcat_example)

# Add the Age of the patients as potential predictor
siamcat_age_added <- add.meta.pred(siamcat_example, pred.names=c('Age'))

# Add Age and BMI as potential predictors
# Additionally, prevent standardization of the added features
siamcat_meta_added <- add.meta.pred(siamcat_example, 
    pred.names=c('Age', 'BMI'), std.meta=FALSE)
}
\keyword{SIAMCAT}
\keyword{add.meta.pred}
