% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCFA.R
\name{SCFA.class}
\alias{SCFA.class}
\title{SCFA.class}
\usage{
SCFA.class(dataListTrain, trainLabel, dataListTest, ncores = 10L, seed = NULL)
}
\arguments{
\item{dataListTrain}{List of training data matrices. In each matrix, rows represent samples and columns represent genes/features.}

\item{trainLabel}{Survival information of patient in training set in form of Surv object.}

\item{dataListTest}{List of testing data matrices. In each matrix, rows represent samples and columns represent genes/features.}

\item{ncores}{Number of processor cores to use.}

\item{seed}{Seed for reproducibility, you still need to use set.seed function for full reproducibility.}
}
\value{
A vector of risk score predictions for patient in test set.
}
\description{
Perform risk score prediction on input data. This function requires training data with survival information. The output is the risk scores of patients in testing set.
}
\examples{
#Load example data (GBM dataset)
data("GBM")
#List of one matrix (microRNA data)
dataList <- GBM$data
#Survival information
survival <- GBM$survival
library(survival)
#Split data to train and test
set.seed(1)
idx <- sample.int(nrow(dataList[[1]]), round(nrow(dataList[[1]])/2) )
survival$Survival <- survival$Survival - min(survival$Survival) + 1 # Survival time must be positive
trainList <- lapply(dataList, function(x) x[idx, ] )
trainSurvival <- Surv(time = survival[idx,]$Survival, event =  survival[idx,]$Death)
testList <- lapply(dataList, function(x) x[-idx, ] )
testSurvival <- Surv(time = survival[-idx,]$Survival, event =  survival[-idx,]$Death)
#Perform risk prediction
result <- SCFA.class(trainList, trainSurvival, testList, seed = 1, ncores = 2L)
#Validation using concordance index
c.index <- concordance(coxph(testSurvival ~ result))$concordance
print(c.index)
}
