% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreMethods.R
\docType{methods}
\name{sc3}
\alias{sc3}
\alias{sc3.SingleCellExperiment}
\alias{sc3,SingleCellExperiment-method}
\alias{sc3}
\title{Run all steps of \code{SC3} in one go}
\usage{
sc3.SingleCellExperiment(object, ks, gene_filter, pct_dropout_min,
  pct_dropout_max, d_region_min, d_region_max, svm_num_cells, svm_train_inds,
  svm_max, n_cores, kmeans_nstart, kmeans_iter_max, k_estimator, biology,
  rand_seed)

\S4method{sc3}{SingleCellExperiment}(object, ks = NULL, gene_filter = TRUE,
  pct_dropout_min = 10, pct_dropout_max = 90, d_region_min = 0.04,
  d_region_max = 0.07, svm_num_cells = NULL, svm_train_inds = NULL,
  svm_max = 5000, n_cores = NULL, kmeans_nstart = NULL,
  kmeans_iter_max = 1e+09, k_estimator = FALSE, biology = FALSE,
  rand_seed = 1)
}
\arguments{
\item{object}{an object of \code{SingleCellExperiment} class.}

\item{ks}{a range of the number of clusters \code{k} used for \code{SC3} clustering.
Can also be a single integer.}

\item{gene_filter}{a boolen variable which defines whether to perform gene 
filtering before SC3 clustering.}

\item{pct_dropout_min}{if \code{gene_filter = TRUE}, then genes with percent of dropouts smaller than 
\code{pct_dropout_min} are filtered out before clustering.}

\item{pct_dropout_max}{if \code{gene_filter = TRUE}, then genes with percent of dropouts larger than 
\code{pct_dropout_max} are filtered out before clustering.}

\item{d_region_min}{defines the minimum number of eigenvectors used for 
kmeans clustering as a fraction of the total number of cells. Default is \code{0.04}.
See \code{SC3} paper for more details.}

\item{d_region_max}{defines the maximum number of eigenvectors used for 
kmeans clustering as a fraction of the total number of cells. Default is \code{0.07}.
See \code{SC3} paper for more details.}

\item{svm_num_cells}{number of randomly selected training cells to be used 
for SVM prediction. The default is \code{NULL}.}

\item{svm_train_inds}{a numeric vector defining indeces of training cells 
that should be used for SVM training. The default is \code{NULL}.}

\item{svm_max}{define the maximum number of cells below which SVM is not run.}

\item{n_cores}{defines the number of cores to be used on the user's machine. If not set, `SC3` will use all but one cores of your machine.}

\item{kmeans_nstart}{nstart parameter passed to \code{\link[stats]{kmeans}} function. Can be set manually. By default it is 
\code{1000} for up to \code{2000} cells and \code{50} for more than \code{2000} cells.}

\item{kmeans_iter_max}{iter.max parameter passed to \code{\link[stats]{kmeans}} 
function.}

\item{k_estimator}{boolean parameter, defines whether to estimate an optimal number of clusters \code{k}. If user has already defined the ks parameter the estimation does not affect the user's paramater.}

\item{biology}{boolean parameter, defines whether to compute differentially expressed genes, marker 
genes and cell outliers.}

\item{rand_seed}{sets the seed of the random number generator. \code{SC3} is a stochastic
method, so setting the \code{rand_seed} to a fixed values can be used for reproducibility
purposes.}
}
\value{
an object of \code{SingleCellExperiment} class
}
\description{
This function is a wrapper that executes all steps of \code{SC3} analysis in one go.
}
