% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plotTpcaVolcano}
\alias{plotTpcaVolcano}
\title{Plot TPCA analysis results}
\usage{
plotTpcaVolcano(tpcaObj, alpha = 0.1)
}
\arguments{
\item{tpcaObj}{a tpcaObj after having performed
a differential analysis, see \code{runDiffTPCA}}

\item{alpha}{significance level / FDR at which 
null hypothesis should be rejected}
}
\value{
ggplot displaying a volcano plot
}
\description{
Plot TPCA analysis results
}
\examples{
library(dplyr)
library(Biobase)

m1 <- matrix(1:28, ncol = 4)
m2 <- matrix(2:25, ncol = 4)
m3 <- matrix(c(2:10, 1:19), ncol = 4)

rownames(m1) <- 1:7
rownames(m2) <- 3:8
rownames(m3) <- 2:8

mat_list <- list(
    m1, m2, m3
)

complex_anno <- tibble(
    protein = c("3", "4", "5", 
       "4", "5", "6", "7"),
    id = c(rep("1", 3), rep("2", 4)),
    count = c(rep(3, 3), rep(4, 4)))

tpca_result <- runTPCA(
  mat_list, complexAnno = complex_anno)

plotTpcaVolcano(tpca_result)

}
