% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetByPair.R
\name{subsetByPair}
\alias{subsetByPair}
\title{Subset RqcResultSet object by pair files.}
\usage{
subsetByPair(rqcResultSet, pair)
}
\arguments{
\item{rqcResultSet}{list of \code{RqcResultSet} objects created by
\code{\link{rqc}} and \code{\link{rqcQA}} functions.}

\item{pair}{index of the pair}
}
\value{
list of \code{RqcResultSet} objects from only one pair.
}
\description{
This function subsets RqcResultSet object function by pair files.
}
\examples{

checkpoint("Rqc", path=system.file(package="Rqc", "extdata"), {
  folder <- system.file(package="ShortRead", "extdata/E-MTAB-1147")
  files <- list.files(full.names=TRUE, path=folder)
  rqcResultSet <- rqcQA(files, pair=c(1,1), workers=1)
}, keep="rqcResultSet")
perFileInformation(subsetByPair(rqcResultSet, 1))

}
\author{
Welliton Souza
}
\keyword{qc}
