% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rqcGroupCycleAverageQualityCalc.R,
%   R/rqcGroupCycleAverageQualityPlot.R
\name{rqcGroupCycleAverageQualityCalc}
\alias{rqcGroupCycleAverageQualityCalc}
\alias{rqcGroupCycleAverageQualityPlot}
\title{Per group average quality across cycles}
\usage{
rqcGroupCycleAverageQualityCalc(rqcResultSet)

rqcGroupCycleAverageQualityPlot(rqcResultSet)
}
\arguments{
\item{rqcResultSet}{list of \code{RqcResultSet} objects created by \code{\link{rqc}} and \code{\link{rqcQA}} functions.}
}
\value{
ggplot2 object
}
\description{
This function plots cycle-specific quality by groups
}
\section{Functions}{
\itemize{
\item \code{rqcGroupCycleAverageQualityCalc}: calculates necessary statistics
}}

\examples{
checkpoint("Rqc", path=system.file(package="Rqc", "extdata"), {
  folder <- system.file(package="ShortRead", "extdata/E-MTAB-1147")
  files <- list.files(full.names=TRUE, path=folder)
  rqcResultSet <- rqcQA(files, pair=c(1,1), workers=1)
}, keep="rqcResultSet")
rqcGroupCycleAverageQualityPlot(rqcResultSet)
}
\seealso{
\code{\link{rqcCycleAverageQualityPlot}} plots cycle-specific quality by files
}
\author{
Welliton Souza
}
\keyword{graphics}
\keyword{qc}
