% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{fit}
\alias{fit}
\alias{fit,Rnits-method}
\alias{fit,character,ANY-method}
\title{Fit model on time series data}
\usage{
fit(object, cluster = TRUE, B = 100, verbatim = FALSE, nclus = NULL,
  modelhistplot = FALSE, seed = 123, gene.level = TRUE,
  clusterallsamples = FALSE, model = NULL)

\S4method{fit}{Rnits}(object, cluster = TRUE, B = 100, verbatim = FALSE,
  nclus = NULL, modelhistplot = FALSE, seed = 123, gene.level = TRUE,
  clusterallsamples = FALSE, model = NULL)
}
\arguments{
\item{object}{\code{\linkS4class{Rnits}} object}

\item{cluster}{if \code{TRUE}, perform clustering to identify groups of
genes/probes with similar expression profiles.}

\item{B}{Default \code{100}. Number of bootstrap iterations for p-value
calculation}

\item{verbatim}{If \code{FALSE}, print out details of fitting models.}

\item{nclus}{Default \code{NULL}. Number of clusters to use for k-means
clustering.}

\item{modelhistplot}{If \code{TRUE}, p-value histograms of multiple
models are plotted.}

\item{seed}{Random seed for bootstrap iterations}

\item{gene.level}{If \code{TRUE}, collapse probes to gene level information.}

\item{clusterallsamples}{If \code{TRUE}, Use all time series for clustering.
By default, only the sample labeled 'control' is used or the lexically
first sample is used.}

\item{model}{A data frame with fields 'degree' and 'df' indicating a specific
B-spline model to be used. If provided, model selection is not run.}
}
\value{
An object of S4 class \code{\linkS4class{Rnits}} with fitted results
data containing cluster information, ratio statistics and p-values.
}
\description{
Fit a model comparing time series data set \code{\linkS4class{Rnits}} objects
}
\details{
The function compares multiple time-series expression data sets by i) (optional)
summarizing probes into gene-level information ii) (optional) identifying a set
of co-expressed genes by clustering iii) For each cluster (or for all genes
/probes), fit a series of B-splines with varying curvature and degrees of
freedom. Under the null hypothesis \code{H_0}, a single model is fit for
all data sets, while under \code{H_1}, each data set is fit separately.
P-values from the hypothesis test are then plotted and the least complex
spline parameters that result in uniformly distributed null p-values are
automatically chosen.
}
\examples{
# load pre-compiled expressionSet object for Ronen and Botstein yeast  chemostat data
data(yeastchemostat)
rnitsobj = build.Rnits(yeastchemostat, logscale = TRUE, normmethod = 'Between')
\dontrun{
# Fit model using gene-level summarization
rnitsobj <- fit(rnitsobj, gene.level = TRUE, clusterallsamples = FALSE)
}
}

