% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve.R
\name{plot_power_curve}
\alias{plot_power_curve}
\title{plot_power_curve}
\usage{
plot_power_curve(
  result,
  cexLegend = 1,
  type = "b",
  xlab = "Sample Size",
  ylab = "Power",
  pch = 16,
  lwd = 3,
  las = 1,
  cex = 1.5,
  main = "Power Curve",
  col = "red"
)
}
\arguments{
\item{result}{the result of \code{\link{sample_size}} or \code{\link{est_power_curve}} function. 
The storeProcess parameter should be set as True when performing \code{\link{sample_size}} 
function. If you want to plot more than one curves in the same figure, the results from 
\code{\link{sample_size}} function should first be combined into a new list. At most five curves
 were allowed in one figure.}

\item{cexLegend}{the cex for legend.}

\item{type}{1-character string giving the type of plot desired. The following values are 
possible, for details, see plot.}

\item{xlab}{a label for the x axis, defaults to a description of x.}

\item{ylab}{a label for the y axis, defaults to a description of y.}

\item{pch}{Either an integer specifying a symbol or a single character to be used as the default
in plotting points.}

\item{lwd}{The line width.}

\item{las}{Numeric in {0,1,2,3}; the style of axis labels.}

\item{cex}{A numerical value giving the amount by which plotting text and symbols should be 
magnified relative to the default.}

\item{main}{a main title for the plot}

\item{col}{The line color.}
}
\value{
A power curve plot.
}
\description{
A function to plot power curves based on the result of \code{\link{sample_size}} or \code{\link{est_power_curve}} function.
}
\examples{
result1<-sample_size(rho=2,phi0=1,lambda0=1,f=0.01,power=0.8,m=20000,m1=500,
showMessage=TRUE,storeProcess=TRUE)
result2<-sample_size(rho=4,phi0=1,lambda0=1,f=0.01,power=0.8,m=20000,m1=500,
showMessage=TRUE,storeProcess=TRUE)
plot_power_curve(list(result1,result2))
}
