% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qualityControl.R
\name{rnb.execute.quality}
\alias{rnb.execute.quality}
\title{rnb.execute.quality}
\usage{
rnb.execute.quality(
  object,
  type = "sites",
  qc.coverage.plots = rnb.getOption("qc.coverage.plots"),
  verbose = TRUE
)
}
\arguments{
\item{object}{Methylation dataset as an object of class \code{\linkS4class{RnBeadSet}},
\code{\linkS4class{RnBeadRawSet}} or \code{\linkS4class{RnBiseqSet}}.}

\item{type}{\code{character} vector of length \code{1} giving the type of genomic regions for which the
quality control information is summarized.}

\item{qc.coverage.plots}{Flag indicating if sequencing coverage information is summarized and returned. This
parameter is considered only when \code{object} is of type \code{\linkS4class{RnBiseqSet}}.}

\item{verbose}{Flag specifying whether diagnostic output should be written to the console or to the
RnBeads logger in case the latter is initialized.}
}
\value{
\code{\linkS4class{RnBeadSet}} object with imputed quality control information
}
\description{
Performs quality control calculations on the loaded DNA methylation data set.
}
\details{
Currently, summarizing coverage for \code{\linkS4class{RnBiseqSet}} object is the only available function.
}
\author{
Pavlo Lutsik
}
