% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/immune.R
\name{rnb.execute.lump}
\alias{rnb.execute.lump}
\title{Leukocytes unmethylation for purity}
\usage{
rnb.execute.lump(dataset)
}
\arguments{
\item{dataset}{Methylation dataset to study, provided as an object of type inheriting \code{RnBSet}.}
}
\value{
Purity esimates provided as a \code{vector} of values in the range \code{[0, 1]}. The attribute
        \code{"sites"} contains the number of sites used in estimating the immune cell proportions. In case the
        dataset does not contain measurements for any of the sites on which LUMP focuses, the return values is
        \code{NULL}.
}
\description{
Implementation of the LUMP (Leukocytes UnMethylation for Purity) algorithm for purity estimation on methylation
datasets.
}
\details{
The LUMP algorithm is developed by Dvir Aran, Marina Sirota and Atul J. Buttea.
}
\author{
Yassen Assenov
}
