% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{rnb.annotation2data.frame}
\alias{rnb.annotation2data.frame}
\title{rnb.annotation2data.frame}
\usage{
rnb.annotation2data.frame(annotation.table, add.names = TRUE)
}
\arguments{
\item{annotation.table}{Annotation in the form of non-empty \code{GRangesList} object, as returned by
\code{\link{rnb.get.annotation}}.}

\item{add.names}{Flag indicating if element names should be extracted and returned also as a column named
\code{"ID"} in the resulting \code{data.frame}. Note that element names, if present, are
set to be the row names of the table.}
}
\value{
Annotation in the form of a single \code{data.frame}. The columns in this table include, among other,
        \code{"Chromosome"}, \code{"Start"} and \code{"End"}.
}
\description{
Transform the specified site, probe or region annotation to \code{data.frame}.
}
\examples{
\donttest{
library(RnBeads.hg19)
head(rnb.annotation2data.frame(rnb.get.annotation("probes450")))
}
}
\author{
Yassen Assenov
}
