% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataImport.R
\name{read.data.dir}
\alias{read.data.dir}
\title{read.data.dir}
\usage{
read.data.dir(
  dir,
  pheno,
  betas,
  p.values,
  bead.counts,
  sep = rnb.getOption("import.table.separator"),
  verbose = TRUE
)
}
\arguments{
\item{dir}{directory containing the table files}

\item{pheno}{a file containing data sample annotations and phenotypic information}

\item{betas}{a file containing the beta values. If not supplied, the routine will look in dir for a file containing "beta" token in the filename}

\item{p.values}{a file containing the detection p values. If not supplied, the routine will look in dir for a file containing "pval" token in the filename}

\item{bead.counts}{a file containing the bead counts (optional). If not supplied, the routine will look in dir for a file containing "bead" token in the filename}

\item{sep}{character used as field separator in the tables files. Default value is taken by the call to \code{rnb.getOption("import.table.separator")}}

\item{verbose}{Flag indicating ifthe messages to the logger should be sent. Note that the logger must be initialized prior to calling this function.
Logging is useful for keeping a record of the downloaded and processed samples. Also, informative messages are stored in case of an error.}
}
\value{
Object of type \code{\linkS4class{RnBeadSet}}.
}
\description{
Reads in a directory with Illumina Infinium HumanMethylation450 data. The files shoudl be stored as data
}
\details{
Colnames in all files should match. They will be returned as the samples element of the list.
}
\author{
Pavlo Lutsik
}
