% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_splice_sites.R
\name{extract_splice_sites}
\alias{extract_splice_sites}
\title{Extract splice sites from annotation}
\usage{
extract_splice_sites(features, outfile, min_length = 5)
}
\arguments{
\item{features}{Either the path to a gtf/gff3 file containing the genomic
features, a GRanges object or a TxDb object.}

\item{outfile}{Character scalar. The path to a text file where the extracted
splice sites will be written.}

\item{min_length}{Integer scalar. Junctions corresponding to introns below
this size will not be reported. The default setting in HISAT2 is 5.}
}
\value{
Nothing is returned, but the splice junction coordinates are written
  to \code{outfile}.
}
\description{
This function extracts splice sites from an annotation object (a gtf/gff3
file, a \code{GRanges} object or a \code{TxDb} object) and saves them in a
text file formatted such that it can be directly used with HISAT2, by
providing it as the argument \code{known-splicesite-infile}.
}
\examples{
tmp <- tempfile()
extract_splice_sites(features=system.file("extdata/refs/genes.gtf",
                                          package="Rhisat2"),
                     outfile=tmp, min_length=5)

}
\references{
Kim D, Langmead B and Salzberg SL. HISAT: a fast spliced aligner with low
memory requirements. Nature Methods 12:357-360 (2015).
}
\author{
Charlotte Soneson
}
