% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regenrichClasses.R
\name{newTopNetwork}
\alias{newTopNetwork}
\title{TopNetwork object creator}
\usage{
newTopNetwork(
  networkEdgeTable,
  reg = "",
  directed = TRUE,
  networkConstruction = c("new", "COEN", "GRN"),
  percent = 100
)
}
\arguments{
\item{networkEdgeTable}{a data frame of 3 columns, representing 'from.gene'
('regulators'), 'to.gene' ('targets') and 'weight', respectively.}

\item{reg}{a vector of gene regulators.}

\item{directed}{logical, whether the network is directed. Default is TRUE.}

\item{networkConstruction}{the method to construct this network.
Possible can be:
'COEN', coexpression network;
'GRN', gene regulatory network by random forest;
'new' (default), meaning a network provided by user, rather than
infered based
on the expression data.}

\item{percent}{the percentage of edges in the original whole network.
Default is 100, meaning 100\% edges in whole network.}
}
\value{
an object of topNetwork class.
}
\description{
This function create `TopNetwork` object using 3-column edge table.
}
\examples{
data(TFs)
edge = data.frame(from = rep(TFs$TF_name[seq(3)], seq(3)),
                  to = TFs$TF_name[11:16], weight = 0.1*(6:1))
object = newTopNetwork(edge, networkConstruction = 'new', percent = 100)
object
str(object)
}
