% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-ReducedExperiment.R
\name{show}
\alias{show}
\alias{show,ReducedExperiment-method}
\title{Prints a summary of a ReducedExperiment object}
\usage{
\S4method{show}{ReducedExperiment}(object)
}
\arguments{
\item{object}{\link[ReducedExperiment]{ReducedExperiment} object.}
}
\value{
A character summary describing the object.
}
\description{
Prints a summary of a ReducedExperiment object
}
\examples{
# Create randomised data with the following dimensions
i <- 300 # Number of features
j <- 100 # Number of samples
k <- 10 # Number of factors

rand_assay_data <- ReducedExperiment:::.makeRandomData(i, j, "gene", "sample")
rand_reduced_data <- ReducedExperiment:::.makeRandomData(j, k, "sample", "component")

re <- ReducedExperiment(
    assays = list("normal" = rand_assay_data),
    reduced = rand_reduced_data
)

# Equivalent to `show(re)`
re

}
\author{
Jack Gisby
}
