% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features.R
\name{modulePreservation}
\alias{modulePreservation}
\title{Get module preservation statistics}
\usage{
modulePreservation(
  reference_dataset,
  test_dataset,
  reference_assay_name = "normal",
  test_assay_name = "normal",
  module_assignments = NULL,
  greyName = "module_0",
  goldName = "random",
  networkType = "signed",
  corFnc = "cor",
  savePermutedStatistics = FALSE,
  ...
)
}
\arguments{
\item{reference_dataset}{The dataset that was used to define the modules.
Must be a \code{data.frame} or \code{matrix} with features as rows and samples as
columns, or a \link[ReducedExperiment]{ModularExperiment} or
\link[SummarizedExperiment]{SummarizedExperiment} object.}

\item{test_dataset}{The dataset that will be used to test for module
preservation. Must be a \code{data.frame} or \code{matrix} with features as rows and
samples as columns, or a \link[SummarizedExperiment]{SummarizedExperiment}
object. The features of \code{test_dataset} should be the same as
\code{reference_dataset} and in the same order.}

\item{reference_assay_name}{If the reference dataset is a
\link[ReducedExperiment]{ModularExperiment} or
\link[SummarizedExperiment]{SummarizedExperiment} object, this argument
specifies which assay slot was used to define the modules.}

\item{test_assay_name}{If the reference dataset is a
\link[ReducedExperiment]{ModularExperiment} or
\link[SummarizedExperiment]{SummarizedExperiment} object, this argument
specifies which assay slot is to be used in preservation tests.}

\item{module_assignments}{If the reference dataset is not a
\link[ReducedExperiment]{ModularExperiment} object, this argument is
necessary to specify the module assignments.}

\item{greyName}{The name of the "module" of unassigned genes. Usually
"module_0" (ReducedExperiment default) or "grey" (WGCNA default). See
\link[WGCNA]{modulePreservation}.}

\item{goldName}{The name to be used for the "gold" module (which is made up
of a random sample of all network genes). See
\link[WGCNA]{modulePreservation}.}

\item{networkType}{A string referring to the type of WGCNA network used for
the reference and test datasets. One of"unsigned", "signed" or
"signed hybrid". See \link[WGCNA]{adjacency}. See
\link[WGCNA]{modulePreservation}.}

\item{corFnc}{A string referring to the function to be used to calculate
correlation. One of "cor" or "bicor". See
\link[WGCNA]{modulePreservation}.}

\item{savePermutedStatistics}{If \code{TRUE}, saves the permutation statistics
as a .RData file. See \link[WGCNA]{modulePreservation}.}

\item{...}{Additional arguments to be passed to
\link[WGCNA]{modulePreservation}.}
}
\value{
A \code{data.frame} containing preservation statistics, as described
by \link[WGCNA]{modulePreservation}.
}
\description{
Tests whether a set of modules defined in the reference dataset are
preserved in the test dataset. Provides a convenient wrapper
around \link[WGCNA]{modulePreservation} for
\link[ReducedExperiment]{ModularExperiment} and
\link[SummarizedExperiment]{SummarizedExperiment}
objects.
}
\examples{
# Get random ModularExperiments with rnorm, with 100 rows (features),
# 20 columns (observations) and 5/10 modules
me_1 <- ReducedExperiment:::.createRandomisedModularExperiment(100, 20, 5)
me_2 <- ReducedExperiment:::.createRandomisedModularExperiment(100, 20, 10)

# Test module preservation (test modules from dataset 1 in dataset 2)
mp <- modulePreservation(me_1, me_2, verbose = 0, nPermutations = 3)

}
\author{
Jack Gisby
}
