% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features.R
\name{getCommonFeatures}
\alias{getCommonFeatures}
\title{Get common factor features}
\usage{
getCommonFeatures(factor_features)
}
\arguments{
\item{factor_features}{A \code{data.frame} as returned by
\link[ReducedExperiment]{getAlignedFeatures}.}
}
\value{
A \code{data.frame} for each factor pair with the numbers and proportions
of the genes in the input that overlap.
}
\description{
Function to count how many genes are aligned with multiple factors.
}
\examples{
# Get a random matrix with rnorm, with 100 rows (features)
# and 20 columns (observations)
X <- ReducedExperiment:::.makeRandomData(100, 20, "feature", "obs")

# Estimate 5 factors based on the data matrix
fe <- estimateFactors(X, nc = 5)

# Get the genes highly aligned with each factor
aligned_features <- getAlignedFeatures(
    fe,
    format = "data.frame",
    proportional_threshold = 0.3
)

# Identify overlap between common features for each factor
common_features <- getCommonFeatures(aligned_features)
head(common_features)

}
\seealso{
\code{\link[=plotCommonFeatures]{plotCommonFeatures()}},
\code{\link[=getAlignedFeatures]{getAlignedFeatures()}}
}
\author{
Jack Gisby
}
