% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factors.R
\name{estimateFactors}
\alias{estimateFactors}
\title{Perform dimensionality reduction using Independent Component Analysis}
\usage{
estimateFactors(
  X,
  nc,
  center_X = TRUE,
  scale_X = FALSE,
  assay_name = "normal",
  ...
)
}
\arguments{
\item{X}{Either a \link[SummarizedExperiment]{SummarizedExperiment} object
or a matrix containing data to be subject to ICA. \code{X} should have rows as
features and columns as samples.}

\item{nc}{The number of components to be identified. See
\link[ReducedExperiment]{estimateStability} for a method to estimate the
optimal number of components.}

\item{center_X}{If \code{TRUE}, X is centered (i.e., features / rows are transformed
to have a mean of 0) prior to ICA. Generally recommended.}

\item{scale_X}{If \code{TRUE}, X is scaled (i.e., features / rows are transformed
to have a standard deviation of 1) before ICA.}

\item{assay_name}{If \code{X} is a
\link[SummarizedExperiment]{SummarizedExperiment}, then this should be the
name of the assay to be subject to ICA.}

\item{...}{Additional arguments to be passed to
\link[ReducedExperiment]{runICA}.}
}
\value{
A \link[ReducedExperiment]{FactorisedExperiment} is returned
containing the input data (i.e., the original data matrix in addition to
other slots if a \link[SummarizedExperiment]{SummarizedExperiment} was used
as input). Additionally contains the results of factor analysis, stored in
the \code{reduced} and \code{loadings} slots. The \code{center_X}, \code{scale_X} and
\code{stability} slots may also be filled depending on the arguments given
to \code{estimateFactors}.
}
\description{
Performs independent component analysis (ICA) and packages both the input
data and subsequent results into a
\link[ReducedExperiment]{FactorisedExperiment} container. Calls
\link[ReducedExperiment]{runICA} to perform the analysis; see its
documentation page for more information on the ICA method, parameters
and outputs.
}
\examples{
# Get a random matrix with rnorm, with 100 rows (features)
# and 20 columns (observations)
X <- ReducedExperiment:::.makeRandomData(100, 20, "feature", "obs")

# Estimate 5 factors based on the data matrix
set.seed(1)
fe_1 <- estimateFactors(X, nc = 5)
fe_1

# Convert the data matrix to a SummarizedExperiment, then estimate 5 factors
se <- SummarizedExperiment(assays = list("normal" = X))
set.seed(1)
fe_2 <- estimateFactors(se, nc = 5)
fe_2

}
\seealso{
\code{\link[=runICA]{runICA()}}, \code{\link[ica:ica]{ica::ica()}}
}
\author{
Jack Gisby
}
