% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gseAnalyzer.R
\name{gsePathway}
\alias{gsePathway}
\title{gsePathway}
\usage{
gsePathway(
  geneList,
  organism = "human",
  exponent = 1,
  minGSSize = 10,
  maxGSSize = 500,
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH",
  verbose = TRUE,
  nPerm = 1000,
  method = "multilevel",
  adaptive = FALSE,
  minPerm = 101,
  maxPerm = 1e+05,
  pvalThreshold = 0.1
)
}
\arguments{
\item{geneList}{order ranked geneList}

\item{organism}{organism}

\item{exponent}{weight of each step}

\item{minGSSize}{minimal size of each geneSet for analyzing}

\item{maxGSSize}{maximal size of each geneSet for analyzing}

\item{pvalueCutoff}{pvalue Cutoff}

\item{pAdjustMethod}{pvalue adjustment method}

\item{verbose}{print message or not}

\item{nPerm}{The number of permutations for the "permute" method}

\item{method}{one of "sample", "permute", "multilevel"}

\item{adaptive}{logical}

\item{minPerm}{minimal number of permutations for the "multilevel" method}

\item{maxPerm}{maximal number of permutations for the "multilevel" method}

\item{pvalThreshold}{The p-value threshold for the "multilevel" method}
}
\value{
gseaResult object
}
\description{
Gene Set Enrichment Analysis of Reactome Pathway
}
\author{
Yu Guangchuang
}
