% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_result.R
\name{open_reactome,ReactomeAnalysisResult-method}
\alias{open_reactome,ReactomeAnalysisResult-method}
\title{open_reactome - ReactomeAnalysisResult}
\usage{
\S4method{open_reactome}{ReactomeAnalysisResult}(x, n_visualization = 1, ...)
}
\arguments{
\item{x}{ReactomeAnalysisResult.}

\item{n_visualization}{numeric The index of the visualization to display (default \code{1}).
Use \code{\link{reactome_links}}
to retrieve all available visualizations and their index. By default,
the first visualization is opened.}

\item{...}{Additional parameters passed to downstream functions.}
}
\value{
The opened link
}
\description{
Opens the specified Reactome visualization in the system's default browser.
}
\examples{
# Note: This function only works with a newly created result
# since the visualization links only stay active for 7 days

# load an example result
library(ReactomeGSA.data)
data(griss_melanoma_result)

# get the reactome link - this does only work
# with new results
# open_reactome(griss_melanoma_result)
}
\seealso{
Other ReactomeAnalysisResult functions: 
\code{\link{get_result}()},
\code{\link{names,ReactomeAnalysisResult-method}},
\code{\link{pathways}()},
\code{\link{plot_correlations}()},
\code{\link{plot_gsva_heatmap}()},
\code{\link{plot_gsva_pathway}()},
\code{\link{plot_heatmap}()},
\code{\link{plot_volcano}()},
\code{\link{reactome_links}()},
\code{\link{result_types}()}
}
