% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_result.R
\name{result_types}
\alias{result_types}
\title{result_types}
\usage{
result_types(x)
}
\arguments{
\item{x}{ReactomeAnalysisResult.}
}
\value{
A cacharacter vector of result types.
}
\description{
Retrieves the available result types for the \code{\link{ReactomeAnalysisResult}} object. Currently,
the Reactome Analysis System supports \code{pathways} and gene level \code{fold_changes}
as result types. Not all analysis methods return both data types though.
Use the \code{names} function to find out which datasets are available
in the result object.
}
\examples{
# load an example result object
library(ReactomeGSA.data)
data(griss_melanoma_result)

# get the available result types
result_types(griss_melanoma_result)
}
\seealso{
Other ReactomeAnalysisResult functions: 
\code{\link{get_result}()},
\code{\link{names,ReactomeAnalysisResult-method}},
\code{\link{open_reactome}()},
\code{\link{pathways}()},
\code{\link{plot_correlations}()},
\code{\link{plot_gsva_heatmap}()},
\code{\link{plot_gsva_pathway}()},
\code{\link{plot_heatmap}()},
\code{\link{plot_volcano}()},
\code{\link{reactome_links}()}
}
\concept{ReactomeAnalysisResult functions}
