% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data.R
\name{.format_chunk}
\alias{.format_chunk}
\title{Format the decompressed chunk as an array of the correct type}
\usage{
.format_chunk(decompressed_chunk, metadata, alt_chunk_dim)
}
\arguments{
\item{decompressed_chunk}{Raw vector holding the decompressed bytes for this
chunk.}

\item{metadata}{List produced by \code{.read_array_metadata()} holding the contents
of the \code{.zarray} file.}

\item{alt_chunk_dim}{The dimensions of the array that should be created from
this chunk.  Normally this will be the same as the chunk shape in
\code{metadata}, but when dealing with edge chunks, which may overlap the true
extent of the array, the returned array should be smaller than the chunk
shape.}
}
\value{
A list of length 2.  The first element is the formatted chunk data.
The second is an integer of length 1, indicating if warnings were
encountered when converting types

If "chunk_data" is larger than the space remaining in destination array
i.e. it contains the overflowing elements, these will be trimmed when the
chunk is returned to \code{read_data()}
}
\description{
When a chunk is decompressed it is returned as a vector of raw bytes.  This
function uses the array metadata to select how to convert the bytes into the
final datatype and then converts the resulting output into an array of the
appropriate dimensions, including re-ordering if the original data is in
row-major order.
}
\keyword{internal}
