\name{rareVariantVis}
\alias{rareVariantVis}

\title{
Interactive visualization of rare variants on the chromosome
}
\description{
Reads file containing table of rare variants from one chromosome and provides adequate visualization. Input file can be obtained from function chromosomeVis.
Function outputs visualization html figure in current working directory. Figure illustrates variants (dots) in their genomic coordinates (x axis). Ratio of alternative reads and depth (y axis) gives information about type of variant: homozygous alternative (expected ratio 1) and heterozygous (expected ratio 0.5). Zoom to the figures is possible, by marking the region of interest with mouse left click. Right click induces zoom out and return to the original plot.
Pointing on variants provides basic information about the variant - gene name and position on chromosome.

}
\usage{
rareVariantVis(input, outputFile, sample, chromosomes, append)
}

\arguments{
    \item{input}{Name of the input file (string) containing the table with rare variants generated by chromosomeVis. It can also be the variable with the table itself.}
    \item{outputFile}{Name of the output file (string) with visualisation.}
    \item{sample}{Name of the sample (used only for entitling the charts).}
    \item{chromosomes}{Vector of chromosome names (strings) to be included in the visualisation (all chromosomes by default). Chromosomes included in the parameter but absent in the table are ommited.}
    \item{append}{Logical value indicating whether charts should be appended to the output file without destroying it (FALSE by default).}
}

\value{
    \item{comp1}{function returns html file with visualization of rare variants}
}

\author{
Adam Gudys and Tomasz Stokowy
}

\examples{
file = system.file("extdata", "RareVariants_CoriellIndex_S1.txt",
    package = "RareVariantVis")
rareVariantVis(input=file, "RareVariants_CoriellIndex_S1.html", "CorielIndex")
}

\keyword{ ~visualization }
\keyword{ ~rare varaints }
