% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histogramPlot.R
\name{histogramPlot}
\alias{histogramPlot}
\title{Plot histogram of correlations.}
\usage{
histogramPlot(
  X,
  Y,
  legend,
  breaks = 40,
  title,
  col.X = "red",
  col.Y = "black",
  line = NULL
)
}
\arguments{
\item{X}{A matrix or a list of matrices of estimated gene-gene correlations.}

\item{Y}{A matrix of reference gene-gene correlations (i.e. known underlying correlation structure).}

\item{legend}{A vector of character strings describing the data contained in \code{X} and \code{Y}.}

\item{breaks}{one of:
    \itemize{
      \item a vector giving the breakpoints between histogram cells,
      \item a function to compute the vector of breakpoints,
      \item a single number giving the number of cells for the histogram,
      \item a character string naming an algorithm to compute the
      number of cells (see \sQuote{Details}),
      \item a function to compute the number of cells.
    }
    In the last three cases the number is a suggestion only; as the
    breakpoints will be set to \code{\link{pretty}} values, the number
    is limited to \code{1e6} (with a warning if it was larger).  If
    \code{breaks} is a function, the \code{x} vector is supplied to it
    as the only argument (and the number of breaks is only limited by
    the amount of available memory).
  }

\item{title}{A character string describing title.}

\item{col.X}{A vector or character string defining the color/colors associated with the data contained in \code{X}.}

\item{col.Y}{The color associated with the data in \code{Y}.}

\item{line}{A vector giving the line type.}
}
\value{
\code{histogramPlot} returns a plot.
}
\description{
\code{histogramPlot} plots histograms of correlation values in expression data and
its reference.
}
\details{
The default for breaks is \code{"Sturges"}.
Other names for which algorithms are supplied are \code{"Scott"} and \code{"FD"} / \code{"Freedman-Diaconis"} 
Case is ignored and partial 
matching is used. Alternatively, a function can be supplied which will compute the 
intended number of breaks or the actual breakpoints as a function of \code{x}.
}
\examples{
Y<-simulateGEdata(500, 500, 10, 2, 5, g=NULL, Sigma.eps=0.1, 
250, 100, intercept=FALSE, check.input=FALSE)
Y.hat<-RUVNaiveRidge(Y, center=TRUE, nc_index=251:500, 0, 10, check.input=FALSE)
Y.hat.cor<-cor(Y.hat[,1:100])
try(dev.off(), silent=TRUE)
par(mar=c(5.1, 4.1, 4.1, 2.1), mgp=c(3, 1, 0), las=0, mfrow=c(1, 1))
histogramPlot(Y.hat.cor, Y$Sigma[1:100, 1:100], title="Simulated data", 
legend=c("RUV", "Truth"))
try(dev.off(), silent=TRUE)
histogramPlot(list(Y.hat.cor, cor(Y$Y[, 1:100])), Y$Sigma[1:100, 1:100],
title="Simulated data", col.Y="black", legend=c("RUV", "Raw", "Truth"))
}
\author{
Saskia Freytag
}
