% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateThreshold.R
\name{calculateThreshold}
\alias{calculateThreshold}
\title{Calculates the correlation threshold.}
\usage{
calculateThreshold(
  X,
  exclude,
  index.ref,
  set.size = length(index.ref),
  Weights = NULL,
  thresholds = seq(0.05, 1, 0.05),
  anno = NULL,
  Factor = NULL,
  cpus = 1,
  parallel = FALSE
)
}
\arguments{
\item{X}{A matrix of gene expression values.}

\item{exclude}{A vector of indices of genes to exclude.}

\item{index.ref}{A vector of indices of reference genes used for prioritisation.}

\item{set.size}{An integer giving the size of the set of genes that are to be
prioritised.}

\item{Weights}{A object of class \code{Weights} or a list of weights. The weights
should correspond to \code{Factor}. If \code{NULL} the unweighted correlations are 
used.}

\item{thresholds}{A vector of thresholds; values should be in the range \eqn{[0,1]}.}

\item{anno}{A dataframe or a matrix containing the annotation of arrays in \code{X}.}

\item{Factor}{A character string corresponding to a column name of \code{anno}.}

\item{cpus}{An integer giving the number of cores that are supposed to be used.}

\item{parallel}{A logical value indicating whether parallel comuting should be used.}
}
\value{
\code{calculateThreshold} returns an object of class \code{Threshold}.
An object of class \code{Threshold} is a \code{list} with the following components:
  \itemize{
    \item{\code{Prop.values}}{ A vector of the proportion of prioritized genes.}
    \item{\code{Thresholds}}{ A vector containing the values in \code{threshold}.}
    \item{\code{loess.estimate}}{ An object of class \code{loess}.} 
  }
}
\description{
\code{calculateThreshold} returns the proportion of prioritised genes from a random selection 
for supplied threshold. Furthermore, this function also fits a loess curve to the estimated points. 
This allows the calculation of a threshold for priortisation of genes.
}
\details{
The proportion of prioritized random genes is estimated by drawing 1000 random sets of genes
and calculating how many would be prioritised at every given threshold. A gene is
is prioritised if at least one correlation with a known reference gene is above the
given threshold.
}
\examples{
Y<-simulateGEdata(500, 500, 10, 2, 5, g=NULL, Sigma.eps=0.1, 
250, 100, intercept=FALSE, check.input=FALSE)
anno<-as.matrix(sample(1:4, dim(Y$Y)[1], replace=TRUE))
colnames(anno)<-"Factor"
weights<-findWeights(Y$Y, anno, "Factor")
calculateThreshold(Y$Y, exclude=seq(251,500,1), index.ref=seq_len(10), 
Weights=weights, anno=anno, Factor="Factor")
}
\seealso{
\code{\link{funcThresh}}
}
\author{
Saskia Freytag
}
