% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethods.R
\docType{methods}
\name{tnsPlotCox,TNS-method}
\alias{tnsPlotCox,TNS-method}
\alias{tnsPlotCox}
\title{Cox plots for TNS class objects}
\usage{
\S4method{tnsPlotCox}{TNS}(
  tns,
  regs = NULL,
  pValueCutoff = 1,
  fname = "coxplot",
  fpath = ".",
  ylab = "Regulons and other covariates",
  xlab = "Hazard Ratio (95\% CI)",
  width = 5,
  height = 5,
  xlim = c(0.3, 3),
  sortregs = TRUE,
  plotpdf = FALSE
)
}
\arguments{
\item{tns}{A \linkS4class{TNS} object, which must have passed GSEA2 analysis.}

\item{regs}{An optional string vector specifying regulons to make the plot.}

\item{pValueCutoff}{A numeric value in [0,1]. The p-value cutoff applied to 
the results from the Cox analysis pipeline.}

\item{fname}{A string. The name of the PDF file which will contain the plot.}

\item{fpath}{A string. The directory where the file will be saved.}

\item{ylab}{A string. The label of the y-axis, describing what is represented.}

\item{xlab}{A string. The label of the x-axis.}

\item{width}{A numeric value. The width of the plot.}

\item{height}{A numeric value. The height of the plot.}

\item{xlim}{A vector with 2 values indicating lowest and highest HR values.}

\item{sortregs}{A logical value. If TRUE, regulons are sorted from most negatively 
associatedwith hazard to most positively associated with hazard.}

\item{plotpdf}{A logical value.}
}
\value{
A Cox hazard model plot and statistics.
}
\description{
Plot results from the 'tnsCox' function.
}
\examples{
# load survival data
data(survival.data, package = "RTNsurvival")

# load TNI-object
data(stni, package = "RTN")

stns <- tni2tnsPreprocess(stni, survivalData = survival.data, 
keycovar = c('Age','Grade'), time = 1, event = 2)
stns <- tnsGSEA2(stns)
stns <- tnsCox(stns, regs = c('PTTG1','E2F2','FOXM1'))
tnsPlotCox(stns)

}
