% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutationsTCGA.R
\name{mutationsTCGA}
\alias{mutationsTCGA}
\title{Gather Mutations for TCGA Datasets}
\usage{
mutationsTCGA(
  ...,
  extract.cols = c("Hugo_Symbol", "Variant_Classification", "bcr_patient_barcode"),
  extract.names = TRUE,
  unique = TRUE
)
}
\arguments{
\item{...}{A data.frame or data.frames from TCGA study containing mutations information (\pkg{RTCGA.mutations}).}

\item{extract.cols}{A character specifing the names of columns to be extracted with \code{bcr_patient_barcode}. 
If \code{NULL} all columns are returned.}

\item{extract.names}{Logical, whether to extract names of passed data.frames in \code{...}.}

\item{unique}{Should the outputed data be \link{unique}. By default it's \code{TRUE}.}
}
\description{
Function gathers mutations over multiple TCGA datasets and extracts mutations and further informations about them for desired genes.
See \link[RTCGA.mutations]{mutations}.
}
\note{
Input data.frames should contain column \code{bcr_patient_barcode} if \code{extract.cols} is specified.
}
\section{Issues}{


If you have any problems, issues or think that something is missing or is not
clear please post an issue on 
\href{https://github.com/RTCGA/RTCGA/issues}{https://github.com/RTCGA/RTCGA/issues}.
}

\examples{

library(RTCGA.mutations)
library(dplyr)
mutationsTCGA(BRCA.mutations, OV.mutations) \%>\%
  filter(Hugo_Symbol == 'TP53') \%>\%
  filter(substr(bcr_patient_barcode, 14, 15) == "01") \%>\% # cancer tissue
  mutate(bcr_patient_barcode = substr(bcr_patient_barcode, 1, 12)) -> BRCA_OV.mutations

library(RTCGA.clinical)
survivalTCGA(BRCA.clinical, OV.clinical, extract.cols = "admin.disease_code") \%>\%
  rename(disease = admin.disease_code)-> BRCA_OV.clinical

BRCA_OV.clinical \%>\%
  left_join(BRCA_OV.mutations,
  by = "bcr_patient_barcode") \%>\%
  mutate(TP53 = ifelse(!is.na(Variant_Classification), "Mut",
 "WILDorNOINFO")) -> BRCA_OV.clinical_mutations

BRCA_OV.clinical_mutations \%>\%
  select(times, patient.vital_status, disease, TP53) -> BRCA_OV.2plot
kmTCGA(BRCA_OV.2plot, explanatory.names = c("TP53", "disease"),
       break.time.by = 400, xlim = c(0,2000))

}
\seealso{
\pkg{RTCGA} website \href{http://rtcga.github.io/RTCGA/articles/Visualizations.html}{http://rtcga.github.io/RTCGA/articles/Visualizations.html}.

Other RTCGA: 
\code{\link{RTCGA-package}},
\code{\link{boxplotTCGA}()},
\code{\link{checkTCGA}()},
\code{\link{convertTCGA}()},
\code{\link{datasetsTCGA}},
\code{\link{downloadTCGA}()},
\code{\link{expressionsTCGA}()},
\code{\link{heatmapTCGA}()},
\code{\link{infoTCGA}()},
\code{\link{installTCGA}()},
\code{\link{kmTCGA}()},
\code{\link{pcaTCGA}()},
\code{\link{readTCGA}()},
\code{\link{survivalTCGA}()},
\code{\link{theme_RTCGA}()}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}
}
\concept{RTCGA}
