% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Modifier-roc.R
\name{plotROC}
\alias{plotROC}
\alias{plotROC,Modifier-method}
\alias{plotROC,ModifierSet-method}
\title{ROCR functions for \code{Modifier} and \code{ModifierSet} objects}
\usage{
plotROC(x, coord, ...)

\S4method{plotROC}{Modifier}(
  x,
  coord,
  score = NULL,
  prediction.args = list(),
  performance.args = list(),
  plot.args = list()
)

\S4method{plotROC}{ModifierSet}(
  x,
  coord,
  score = NULL,
  prediction.args = list(),
  performance.args = list(),
  plot.args = list()
)
}
\arguments{
\item{x}{a \code{Modifier} or a \code{ModifierSet} object}

\item{coord}{coordinates of position to label as positive. Either a 
\code{GRanges} or a \code{GRangesList} object. For both types the Parent 
column is expected to match the gene or transcript name.}

\item{...}{additional arguments}

\item{score}{the score identifier to subset to, if multiple scores are 
available.}

\item{prediction.args}{arguments which will be used for calling 
\code{\link[ROCR:prediction]{prediction}} form the \code{ROCR} package}

\item{performance.args}{arguments which will be used for calling 
\code{\link[ROCR:performance]{performance}} form the \code{ROCR} package}

\item{plot.args}{arguments which will be used for calling \code{plot} on the
performance object of the \code{ROCR} package. If multiple scores are plotted
(for example if the score argument is not explicitly set) \code{add = FALSE}
will be set.}
}
\value{
a plot send to the active graphic device
}
\description{
\code{plotROC} streamlines labeling, prediction, performance and plotting
functions to test the peformance of a \code{Modifier} object and the data 
analyzed via the functionallity from the \code{ROCR} package.

The data from \code{x} will be labeled as positive using the \code{coord}
arguments. The other arguments will be passed on to the specific \code{ROCR}
functions.

By default the \code{prediction.args} include three values:
\itemize{
\item \code{measure = "tpr"}
\item \code{x.measure = "fpr"}
\item \code{score = mainScore(x)}
}
The remaining arguments are not predefined.
}
\examples{
data(msi,package="RNAmodR")
# constructing a GRanges obejct to mark positive positions
mod <- modifications(msi)
coord <- unique(unlist(mod))
coord$score <- NULL
coord$sd <- NULL
# plotting a TPR vs. FPR plot per ModInosine object
plotROC(msi[[1]],coord)
# plotting a TPR vs. FPR plot per ModSetInosine object
plotROC(msi,coord)
}
\references{
Tobias Sing, Oliver Sander, Niko Beerenwinkel, Thomas Lengauer (2005): "ROCR:
visualizing classifier performance in R." Bioinformatics 21(20):3940-3941
DOI:
\href{https://doi.org/10.1093/bioinformatics/bti623}{10.1093/bioinformatics/bti623}
}
