% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Modifier-Inosine-class.R
\docType{class}
\name{ModInosine}
\alias{ModInosine}
\alias{Inosine}
\alias{ModifierInosine}
\alias{ICE-Seq}
\alias{ModInosine-class}
\alias{ModSetInosine-class}
\alias{ModSetInosine}
\title{ModInosine}
\usage{
ModInosine(x, annotation, sequences, seqinfo, ...)

ModSetInosine(x, annotation = NA, sequences = NA, seqinfo = NA, ...)
}
\arguments{
\item{x}{the input which can be of the different types depending on whether
a \code{ModRiboMethSeq} or a \code{ModSetRiboMethSeq} object is to be 
constructed. For more information have a look at the documentation of
the \code{\link[RNAmodR:Modifier-class]{Modifier}} and 
\code{\link[RNAmodR:ModifierSet-class]{ModifierSet}} classes.}

\item{annotation}{annotation data, which must match the information contained
in the BAM files. This is parameter is only required, if \code{x} is not a 
\code{Modifier} object.}

\item{sequences}{sequences matching the target sequences the reads were 
mapped onto. This must match the information contained in the BAM files. This
is parameter is only required, if \code{x} is not a \code{Modifier} object.}

\item{seqinfo}{An optional \code{\link[Seqinfo:Seqinfo-class]{Seqinfo}} 
argument or character vector, which can be coerced to one, to subset the 
sequences to be analyzed on a per chromosome basis.}

\item{...}{Optional arguments overwriting default values, which are
\itemize{
\item minCoverage: The minimal coverage at the position as integer value 
(default: \code{minCoverage = 10L}).
\item minReplicate: minimum number of replicates needed for the analysis 
(default: \code{minReplicate = 1L}).
\item minScore: minimum score to identify Inosine positions de novo 
(default: \code{minScore = 0.4}).
}}
}
\value{
a \code{ModInosine} or \code{ModSetInosine} object
}
\description{
Inosine can be detected in RNA-Seq data by the conversion of A positions to 
G. This conversion is detected by \code{ModInosine} and used to search for 
Inosine positions. \code{dataType} is \code{"PileupSequenceData"}.

Only samples labeled with the condition \code{treated} are used for this
analysis, since the A to G conversion is common feature among the reverse
transcriptases usually emploied. Let us know, if that is not the case, and
the class needs to be modified.

Further information on \code{\link[=ModInosine-functions]{Functions}} of 
\code{ModInosine}.
}
\details{
\code{ModInosine} score: the scores for reported Inosine positions are 
between 0 and 1. They are calculated as the relative amount of called G bases 
(\code{(G / N)}) and only saved for genomic A positions.
}
\examples{
# construction of ModInosine object
library(RNAmodR.Data)
library(rtracklayer)
annotation <- GFF3File(RNAmodR.Data.example.man.gff3())
sequences <- RNAmodR.Data.example.man.fasta()
files <- c(treated = RNAmodR.Data.example.wt.1())
mi <- ModInosine(files,annotation = annotation ,sequences = sequences)
# construction of ModSetInosine object
\dontrun{
files <- list("SampleSet1" = c(treated = RNAmodR.Data.example.wt.1(),
                               treated = RNAmodR.Data.example.wt.2(),
                               treated = RNAmodR.Data.example.wt.3()),
              "SampleSet2" = c(treated = RNAmodR.Data.example.bud23.1(),
                               treated = RNAmodR.Data.example.bud23.2()),
              "SampleSet3" = c(treated = RNAmodR.Data.example.trm8.1(),
                               treated = RNAmodR.Data.example.trm8.2()))
msi <- ModSetInosine(files, annotation = annotation, sequences = sequences)
}
}
\author{
Felix G.M. Ernst [aut]
}
