% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_age.R
\name{predict_age}
\alias{predict_age}
\title{Calculate RNA age}
\usage{
predict_age(
  exprdata,
  tissue,
  exprtype = c("FPKM", "counts"),
  idtype = c("SYMBOL", "ENSEMBL", "ENTREZID", "REFSEQ"),
  stype = c("all", "caucasian"),
  signature = NULL,
  genelength = NULL,
  chronage = NULL,
  maxp = NULL
)
}
\arguments{
\item{exprdata}{a matrix or data frame which contains gene expression data
with each row represents a gene and each column represents a sample. Use
the argument `exprtype` to specify raw count or FPKM. The rownames of
`exprdata` should be gene ids and colnames of `exprdata` should be sample
ids.}

\item{tissue}{a string indicate which tissue the gene expression data is
obtained from. Users are expected to provide one of the following tissues.
If the tissue argument is not provide or the provided tissue is not in this
list, then the age predictor trained on all tissues will be used to
calculate RNA age.
\itemize{
  \item adipose_tissue
  \item adrenal_gland
  \item blood
  \item blood_vessel
  \item brain
  \item breast
  \item colon
  \item esophagus
  \item heart
  \item liver
  \item lung
  \item muscle
  \item nerve
  \item ovary
  \item pancreas
  \item pituitary
  \item prostate
  \item salivary_gland
  \item skin
  \item small_intestine
  \item spleen
  \item stomach
  \item testis
  \item thyroid
  \item uterus
  \item vagina
}}

\item{exprtype}{either "counts" or "FPKM". For RPKM data, please use
`exprtype` = "FPKM".}

\item{idtype}{a string which indicates the gene id type in `exprdata`.
It should be one of "SYMBOL", "ENSEMBL", "ENTREZID" or "REFSEQ". Default is
"SYMBOL".}

\item{stype}{a string which specifies which version of pre-trained 
calculators to be used. It should be either "all" or "Caucasian". "all" 
means samples from all races (American Indian/Alaska Native, Asian, 
Black/African American, and Caucasian) are used to obtain the 
pre-trained calculator. "Caucasian" means only the Caucasian samples are 
used to build up the pre-trained calculator.}

\item{signature}{a string which indicates the age signature to use when
calculating RNA age. This argument is not required. \cr
In the case that this argument is not provided, if `tissue` argument is also
provided and the tissue is in the list above, the tissue specific age
signature given by our DESeq2 analysis result on GTEx data will be used.
Otherwise, the across tissue signature "GTExAge" will be used. \cr
In the case that this argument is provided, it should be one of the
following signatures. A detailed description of the meaning of these
signatures is given in the package vignette.
\itemize{
  \item DESeq2
  \item Pearson
  \item Dev
  \item deMagalhaes
  \item GenAge
  \item GTExAge
  \item Peters
  \item all
}}

\item{genelength}{a vector which contains gene length in bp. 
The size of `genelength` should be
equal to the number of rows in `exprdata`. This argument is optional. If
using `exprtype = "FPKM"`, `genelength` argument is ignored. If using
`exprtype = "counts"`, the raw count will be converted to FPKM. If
`genelength` is provided, the function will convert raw count to FPKM by the
user-supplied gene length. Otherwise, gene length is obtained from the
internal database.}

\item{chronage}{a data frame which contains the chronological age of each
sample. This argument is optional. If provided, it should be a dataframe
with 1st column sample id and 2nd column chronological age. The sample order
in `chronage` doesn't have to be in the same order as in
`exprdata`. However, the samples in `chronage` and `exprdata` should be the
same. If some samples' chronological age are not available, users are
expected to set the chronological age in `chronage` to NA. If `chronage`
contains more than 2 columns, only the first 2 columns will be considered.
If this argument is not provided, the age acceleration residual will not be
calculated. See package vignette for the definition of age acceleration
residual.}

\item{maxp}{the maxp argument used in \code{\link[impute]{impute.knn}} 
function. This is optional.}
}
\value{
a data frame contains RNA age.
}
\description{
This function calculates RNA age based on pre-trained
calculators.
}
\examples{
data(fpkmExample)
res = predict_age(exprdata = fpkm, exprtype = "FPKM")
}
