% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count2FPKM.R
\name{count2FPKM}
\alias{count2FPKM}
\title{Converting gene expression data from raw count to FPKM}
\usage{
count2FPKM(rawcount, genelength = NULL, idtype = "SYMBOL")
}
\arguments{
\item{rawcount}{a matrix or data frame which contains gene expression counts
data.}

\item{genelength}{gene length in bp. The size of `genelength` should be
equal to the number of rows in `rawcount`. This argument is optional. If
not provided, gene length is obtained from the internal database.}

\item{idtype}{a string which indicates the gene id type in rawcount matrix.
It should be one of "SYMBOL", "ENSEMBL", "ENTREZID" or "REFSEQ".
Default is "SYMBOL".}
}
\value{
a data frame contains FPKM.
}
\description{
This function converts gene expression data from raw count to
FPKM by using \code{\link[recount]{getRPKM}}
}
\examples{
data(countExample)
head(rawcount)
fpkm = count2FPKM(rawcount)
head(fpkm)
}
\references{
Carlson M (2019). org.Hs.eg.db: Genome wide annotation for
Human. R package version 3.8.2.

Collado-Torres, Leonardo, et al. "Reproducible RNA-seq analysis 
using recount2." Nature biotechnology 35.4 (2017): 319-321.
}
