% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generics.R, R/SpectrumMethods.R
\name{property<-}
\alias{property<-}
\alias{property<-,RmbSpectrum2,character,logical,character-method}
\alias{property<-,RmbSpectrum2,character,missing,character-method}
\alias{property<-,RmbSpectrum2,character,logical,missing-method}
\alias{property<-,RmbSpectrum2,character,missing,missing-method}
\title{Replacement function to set properties of an RmbSpectrum2 object}
\usage{
property(o, property, addNew=FALSE, class="") <- value

\S4method{property}{RmbSpectrum2,character,logical,character}(o, property, addNew = FALSE, class = "") <- value

\S4method{property}{RmbSpectrum2,character,missing,character}(o, property, addNew = FALSE, class = "") <- value

\S4method{property}{RmbSpectrum2,character,logical,missing}(o, property, addNew = FALSE, class = "") <- value

\S4method{property}{RmbSpectrum2,character,missing,missing}(o, property, addNew = FALSE, class = "") <- value
}
\arguments{
\item{o}{\code{RmbSpectrum2}
The object whos 'properties' slot should be updated}

\item{property}{character
The name of the column in the 'properties' data frame to be updated}

\item{addNew}{logical, Default: FALSE
Whether or not a new column should be added in case a column of the
given name does not exist yet.}

\item{class}{character or missing
The class of the entries for the column to be added/updated}

\item{value}{ANY
The value(s) to be written into the column}
}
\value{
The \code{RmbSpectrum2} object with an updated 'properties' slot
}
\description{
Update the 'properties' slot of the given object.
If the column you want to update does not exist yet and
\code{addNew = FALSE} (default), this will cause a warning
and the object will not be changed
}
\details{
Please note that this is a replacement method, meaning that
\code{property(o, property) <- value}
can be used as a short-hand for the equivalent
\code{o <- 'property<-'(o, property, value)}
}
