% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpectraSetMethods.R
\name{checkSpectra}
\alias{checkSpectra}
\alias{checkSpectra,RmbSpectraSet,character-method}
\title{Check if a spectra set is found, complete, empty}
\usage{
checkSpectra(s, property)

\S4method{checkSpectra}{RmbSpectraSet,character}(s, property)
}
\arguments{
\item{s}{The  (\code{RmbSpectraSet}) to check}

\item{property}{The property to check (\code{found}, \code{complete} or \code{empty})}
}
\value{
\code{TRUE} or \code{FALSE}
}
\description{
Checks if a specific compound (\code{RmbSpectraSet}) was found with child spectra in the raw file (\code{found}), 
has a complete set of MS2 spectra with useful peaks (\code{complete}), or is empty (note: spectra are currently not ever
marked empty - empty should mean found, but no useful peaks at all. This is not yet currently tested.)
}
\section{Methods (by class)}{
\itemize{
\item \code{checkSpectra(s = RmbSpectraSet, property = character)}: 

}}
\author{
stravsmi
}
