% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rjmcmcMethod.R
\name{segmentation}
\alias{segmentation}
\title{Split a \code{GRanges} containing reads in a list of smaller
segments for the \code{rjmcmc} function.}
\usage{
segmentation(reads, zeta = 147, delta, maxLength)
}
\arguments{
\item{reads}{a \code{GRanges}, the reads that need to be segmented.}

\item{zeta}{a positive \code{integer} or \code{numeric}, the length
of the nucleosomes. Default: 147.}

\item{delta}{a positive \code{integer} or \code{numeric}, the accepted
range of overlapping section between segments. The overlapping section
being \code{zeta} + \code{delta}.}

\item{maxLength}{a positive \code{integer} or \code{numeric}, the
length of each segment.}
}
\value{
a \code{GRangesList} containing all the segments.
}
\description{
Split a \code{GRanges} of reads (as example, the reads from
a chromosome) in a \code{list} of smaller \code{GRanges} sot that the
\code{rjmcmc} function can be run on each segments.
}
\examples{

## Load synthetic dataset of reads
data(syntheticNucleosomeReads)

## Use dataset of reads to create GRanges object
sampleGRanges <- GRanges(seqnames = syntheticNucleosomeReads$dataIP$chr,
    ranges = IRanges(start = syntheticNucleosomeReads$dataIP$start,
    end = syntheticNucleosomeReads$dataIP$end),
    strand = syntheticNucleosomeReads$dataIP$strand)

# Segmentation of the reads
segmentation(reads = sampleGRanges, zeta = 147, delta = 50,
maxLength = 1000)

}
\author{
Pascal Belleau, Astrid Deschenes
}
