% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcRIVER.R
\name{mleTheta}
\alias{mleTheta}
\title{Maximum likelihoood estimate of theta.}
\usage{
mleTheta(Out, FuncRv, pseudocount)
}
\arguments{
\item{Out}{Binary values of outlier status (E).}

\item{FuncRv}{Soft-assignments of FR from E-step}

\item{pseudocount}{Pseudo count.}
}
\value{
MLE of theta
}
\description{
\code{mleTheta} computes maximum likelihoood estimate of theta (parameters
        between FR (functionality of regulatory variant) and E (outlier
        status); Naive-Bayes).
}
\examples{
dataInput <- getData(filename=system.file("extdata", "simulation_RIVER.gz",
        package = "RIVER"), ZscoreThrd=1.5)
Feat <- scale(t(Biobase::exprs(dataInput))) # genomic features (G)
Out <- as.vector(as.numeric(unlist(dataInput$Outlier))-1) # outlier status (E)
theta.init <- matrix(c(.99, .01, .3, .7), nrow=2)
costs <- c(100, 10, 1, .1, .01, 1e-3, 1e-4)
logisticAllCV <- glmnet::cv.glmnet(Feat, Out, lambda=costs, family="binomial",
        alpha = 0, nfolds=10)
probFuncRvFeat <- getFuncRvFeat(Feat, logisticAllCV$glmnet.fit, logisticAllCV$lambda.min)
posteriors <- getFuncRvPosteriors(Out, probFuncRvFeat, theta=theta.init)
thetaCur <- mleTheta(Out, FuncRv=posteriors$posterior, pseudoc=50)

}
\author{
Yungil Kim, \email{ipw012@gmail.com}
}
