% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dataformating.R
\name{getNodesDataFrame}
\alias{getNodesDataFrame}
\title{Create Nodes \code{data.frame} from Adjacency matrix and properties
for specific nodes}
\usage{
getNodesDataFrame(A, nGlobal = NULL, nProp = NULL)
}
\arguments{
\item{A}{signed weighted adjacency matrix}

\item{nGlobal}{A \code{list} of properties for assigning all nodes.
Default value is \code{NULL}}

\item{nProp}{A \code{data.frame} for assigning some nodes properties
Default value is \code{NULL}}
}
\value{
A \code{data.frame}
}
\description{
Create Nodes \code{data.frame} from Adjacency matrix and properties
for specific nodes
}
\examples{
v <- c(0, 0, 1, 1, 0,
       0, 0, 0, 0, 0,
      -1, 0, 0, 1, 0)
a <- matrix(v, 3, 5)
colnames(a) <- LETTERS[1:5]
rownames(a) <- LETTERS[1:3]
nGlobal <- list(color="#dedeff")
nProp <- data.frame(shape=c('triangle', 'lozenge'))
rownames(nProp) <- c('C', 'E')
getNodesDataFrame(A=a, nGlobal=nGlobal, nProp=nProp)
}
\author{
Sylvain Gubian \email{DL.RSupport@pmi.com}
}

