% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Visualize.R
\name{visualize}
\alias{visualize}
\alias{visualize.RCX}
\alias{visualize.CX}
\title{Visualize a Network}
\usage{
visualize(x, layout = NULL, openExternal = FALSE)

\method{visualize}{RCX}(x, layout = NULL, openExternal = FALSE)

\method{visualize}{CX}(x, layout = NULL, openExternal = FALSE)
}
\arguments{
\item{x}{network; \link[=RCX-object]{RCX} or CX object}

\item{layout}{named character or list; e.g. \code{c(name="random")}}

\item{openExternal}{logical; whether to open in an external browser instead of the RStudio viewer}
}
\value{
\code{NULL}
}
\description{
Visualize \link[=RCX-object]{RCX} and CX networks in RStudio or in an external browser.
}
\details{
This function uses the Java Script library used by the NDEx platform (\url{https://ndexbio.org/}) to visualize
the \link[=RCX-object]{RCX} or CX network from \link{toCX}.
In the first case, the \link[=RCX-object]{RCX} is converted to CX (JSON) using \link{toCX}.

By default the visualization is opened in RStudio in the \emph{Viewer} panel.
If this function is not executed in RStudio, the visualization is opened in the standard web-browser.
This also can be forced from within RStudio using \emph{openExternal}.

If the network contains the necessary Cytoscape styles (see \url{http://manual.cytoscape.org/en/stable/Styles.html})
the network is visualized as seen on the NDEx platform.

To define the layout of the network the coordinate from \link{CartesianLayout} are used to determine the location of
the nodes. If this aspect is missing, or the the coordinates should be ignored, the \emph{layout} parameter can be used
to set a different layout.

\emph{layout} follows therefore the definition of Cytoscape.js (see \url{https://js.cytoscape.org/#layouts}).
A simple definition can be setting only the \emph{name} of the desired layout, e.g. \code{random}.
Additional options can be passed as named list, where the values are passed without quoting.
This allows for even passing Java Script functions to Cytoscape.js.

The visualization can also be saved as HTML file using the \link{writeHTML} function instead of this one.
}
\examples{
## prepare RCX
rcx = createRCX(
  createNodes(name = c("a","b","c")), 
  createEdges(
    source=c(0,0,1), 
    target=c(1,2,2)
  )
)

\donttest{
## visualize the network
 visualize(rcx)

## force a different layout
 visualize(rcx, c(name="cose"))

## force a different layout with Java Script parameters
 visualize(rcx, layout = c(name="random",animate="true"))

## even pass a Java Script function
 visualize(
   rcx, 
   layout = c(
     name="random",
     animate="true",
     animateFilter="function ( node, i ){ return true; }"
   )
 )

## open the visualization in an external browser
 visualize(
   rcx, 
   layout = c(name="cose"),
   openExternal = TRUE
 )
}
}
\seealso{
\link{rcxToJson}, \link{readCX}, \link{writeCX}
}
