% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCX-NodeEdgeNetworkAttributes.R
\name{updateEdgeAttributes}
\alias{updateEdgeAttributes}
\alias{updateEdgeAttributes.EdgeAttributesAspect}
\alias{updateEdgeAttributes.RCX}
\title{Update edge attributes}
\usage{
updateEdgeAttributes(
  x,
  edgeAttributes,
  replace = TRUE,
  stopOnDuplicates = FALSE,
  ...
)

\method{updateEdgeAttributes}{EdgeAttributesAspect}(
  x,
  edgeAttributes,
  replace = TRUE,
  stopOnDuplicates = FALSE,
  ...
)

\method{updateEdgeAttributes}{RCX}(
  x,
  edgeAttributes,
  replace = TRUE,
  stopOnDuplicates = FALSE,
  checkReferences = TRUE,
  ...
)
}
\arguments{
\item{x}{\link[=RCX-object]{RCX} or \code{\link{EdgeAttributes}} object; (to which the new edge attributes will be added)}

\item{edgeAttributes}{\code{\link{EdgeAttributes}} object; (the new aspect, that will be added)}

\item{replace}{logical; if existing values are updated (or ignored)}

\item{stopOnDuplicates}{logical; whether to stop, if duplicates in \emph{propertyOf} and \emph{name} (and \emph{subnetworkId} if present) column are found}

\item{...}{additional parameters}

\item{checkReferences}{logical; whether to check if references to other aspects are present in the \link[=RCX-object]{RCX} object}
}
\value{
\code{\link{EdgeAttributes}} or \link[=RCX-object]{RCX} object with added node attributes
}
\description{
This functions add edge attributes in the form of a \code{\link{EdgeAttributes}} object to an \link[=RCX-object]{RCX} or an other \code{\link{EdgeAttributes}} object.
}
\details{
Edges may have additional attributes besides a name and a representation, and are represented as \code{\link{EdgeAttributes}} objects.
\code{\link{EdgeAttributes}} objects can be added to an \link[=RCX-object]{RCX} or an other \code{\link{EdgeAttributes}} object.
The \emph{propertyOf} parameter references the \code{\link{Edges}} ids to which the attributes belong to.
When adding an \code{\link{EdgeAttributes}} object to an \link[=RCX-object]{RCX} object, those ids must be present in the \code{\link{Edges}}
aspect, otherwise an error is raised.

In the case, that a \code{\link{EdgeAttributes}} object is added to an other, or the \link[=RCX-object]{RCX} object already contains a
\code{\link{EdgeAttributes}} object, some attributes might be present in both. By default, the attributes are updated with the values
of the latest one. This can prevented by setting the \emph{replace} parameter to \emph{FALSE}, in that case only new attributes are added and
the existing attributes remain untouched.

Furthermore, if duplicated attributes are considered as a preventable mistake, an error can be raised by setting \emph{stopOnDuplicates}
to \code{TRUE}. This forces the function to stop and raise an error, if duplicated attributes are present.
}
\examples{
## For EdgeAttributesAspects: 
## prepare some aspects:
edgeAttributes = createEdgeAttributes(
  propertyOf=c(0,0,0,0),
  name=c("A","A","B","B"),
  value=list(c("a1","a2"),
             "a with subnetwork",
             "b",
             "b with subnetwork"),
  isList=c(TRUE,FALSE,TRUE,FALSE),
  subnetworkId=c(NA,1,NA,1)
)

## A is updated, C is new 
edgeAttributes2 = createEdgeAttributes(
  propertyOf=c(0,0,0),
  name=c("A","A","C"),
  value=list("new a",
             "new a with subnetwork",
             c(1,2)),
  subnetworkId=c(NA,1,NA)
)

## Simply update with new values
edgeAttributes3 = updateEdgeAttributes(edgeAttributes, edgeAttributes2)

## Ignore already present keys
edgeAttributes3 = updateEdgeAttributes(edgeAttributes, edgeAttributes2, 
                                       replace=FALSE)

## Raise an error if duplicate keys are present
try(updateEdgeAttributes(edgeAttributes, edgeAttributes2, 
                         stopOnDuplicates=TRUE))
## =>ERROR: 
## Elements of "propertyOf", "name" and "subnetworkId" (in updateEdgeAttributes)
## must not contain duplicates!

## For RCX
## prepare RCX object:
nodes = createNodes(name = c("a","b","c","d","e","f"))
edges = createEdges(source=c(1,2,0,0,0,2), 
                    target=c(2,3,1,2,5,4))
rcx = createRCX(nodes, edges)
cySubNetworks = createCySubNetworks(
  id = c(1,2),
  nodes = list("all", c(1,2,3)),
  edges = list("all", c(0,2))                    
)
rcx = updateCySubNetworks(rcx, cySubNetworks)

## add the edge attributes
rcx = updateEdgeAttributes(rcx, edgeAttributes)

## add additional edge attributes and update existing
rcx = updateEdgeAttributes(rcx, edgeAttributes2)

## create edge attributes for a not existing edge...
edgeAttributes3 = createEdgeAttributes(propertyOf=9, 
                                       name="A", 
                                       value="a")
## ...and try to add them
try(updateEdgeAttributes(rcx, edgeAttributes3))
## =>ERROR: 
## Provided IDs of "additionalAttributes$propertyOf" (in updateEdgeAttributes)
## don't exist in "rcx$edges$id"
}
\seealso{
\code{\link{NodeAttributes}}, \code{\link{NetworkAttributes}}
}
