% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCX-Cytoscape-VisualProperties.R
\name{CyVisualPropertyMappings}
\alias{CyVisualPropertyMappings}
\alias{createCyVisualPropertyMappings}
\title{Create an object for mappings of Cytoscape Visual Properties (object used in CyVisualProperty)}
\usage{
createCyVisualPropertyMappings(type, definition, name = NULL)
}
\arguments{
\item{type}{character or named character; value of the mappings}

\item{definition}{character; definitions of the mappings}

\item{name}{character (optional); names of the mappings}
}
\value{
CyVisualPropertyMappings object
}
\description{
This function is used to create objects for mappings in \link[=CyVisualProperties]{Cytoscape visual properties}.
Networks, nodes, edges, and default nodes and edges mappings are realized as \code{\link{CyVisualProperty}} objects, that each consist of
properties (\code{\link{CyVisualPropertyProperties}} objects), dependencies (\code{\link{CyVisualPropertyDependencies}} objects) and mappings (\strong{this here}).
}
\details{
Cytoscape contributes aspects that organize subnetworks, attribute tables, and visual attributes for use by its own layout and
analysis tools. Furthermore are the aspects used in web-based visualizations like within the NDEx platform.

The visual properties aspect is the only aspect (\code{\link{CyVisualProperties}}) with a complex structure. It is composed of several sub-property classes and
consists of \code{\link{CyVisualProperty}} objects, that belong to, or more precisely describe one of the following network elements:
\emph{network}, \emph{nodes}, \emph{edges}, \emph{defaultNodes} or \emph{defaultEdges}.

A single visual property (i.e. \code{\link{CyVisualProperty}} object) organizes the information as \emph{properties}, \emph{dependencies} and \emph{mappings},
as well as the single values \emph{appliesTo} and \emph{view}, that define the subnetwork or view to which the IDs apply.

Properties are \code{\link{CyVisualPropertyProperties}} objects, that hold information like
\code{"NODE_FILL_COLOR" : "#26CCC9"} or \code{"NODE_LABEL_TRANSPARENCY" : "255"} in a key-value like manner.

Dependencies are \code{\link{CyVisualPropertyDependencies}} objects, that hold information
about dependencies between visual properties.
Currently there are only three dependencies supported:
\itemize{
\item Lock Node with and height: \code{nodeSizeLocked = "false"}
\item Fit Custom Graphics to node: \code{nodeCustomGraphicsSizeSync = "true"}
\item Edge color to arrows: \code{arrowColorMatchesEdge = "false"}
}

Mappings are \code{\link{CyVisualPropertyMappings}} objects, that hold information as a triplet consisting of name, type and definition, like
\code{"NODE_FILL_COLOR" : "DISCRETE" : "COL=molecule_type,T=string,K=0=miRNA,V=0=#FCEC00"},
\verb{"NODE_FILL_COLOR" : "CONTINUOUS" : "COL=gal1RGexp,T=double...} or
\code{"NODE_LABEL" : "PASSTHROUGH" : "COL=COMMON,T=string"}.

For further information about Cytoscape visual properties see the \code{Styles} topic of the official Cytoscape documentation:
\href{http://manual.cytoscape.org/en/stable/Styles.html}{http://manual.cytoscape.org/en/stable/Styles.html}

\subsection{Structure of Cytoscape Visual Properties}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{CyVisualProperties
|---network = CyVisualProperty
|---nodes = CyVisualProperty
|---edges = CyVisualProperty
|---defaultNodes = CyVisualProperty
|---defaultEdges = CyVisualProperty

CyVisualProperty
|---properties = CyVisualPropertyProperties
|   |--name
|   |--value 
|---dependencies = CyVisualPropertyDependencies
|   |--name
|   |--value 
|---mappings = CyVisualPropertyMappings
|   |--name
|   |--type
|   |--definition 
|---appliesTo = <reference to subnetwork id>
|---view = <reference to subnetwork id>
}\if{html}{\out{</div>}}
}
}
\note{
If \emph{name} is not provided, the \emph{names(type)} is used instead to infer the names.
}
\examples{
## Using a named vector
vpMappingNamedType = c(NODE_FILL_COLOR="CONTINUOUS",
                       EDGE_TARGET_ARROW_SHAPE="DISCRETE")
vpMappingDefinition = c("COL=gal1RGexp,T=double,...",
                        "COL=directed,T=boolean,K=0=true,V=0=ARROW")
createCyVisualPropertyMappings(vpMappingNamedType, 
                               vpMappingDefinition)

## Using three separate vectors
vpMappingName = c("NODE_FILL_COLOR", 
                  "EDGE_TARGET_ARROW_SHAPE")
vpMappingType = c("CONTINUOUS", 
                  "DISCRETE")
createCyVisualPropertyMappings(vpMappingType, 
                               vpMappingDefinition, 
                               vpMappingName)

# Result for either:
#                      name       type                                definition
# 1         NODE_FILL_COLOR CONTINUOUS                COL=gal1RGexp,T=double,...
# 2 EDGE_TARGET_ARROW_SHAPE   DISCRETE COL=directed,T=boolean,K=0=true,V=0=ARROW
}
\seealso{
\code{\link{updateCyVisualProperty}}, \code{\link{updateCyVisualProperties}}
}
