% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_respFunScoreMat.R
\name{respFunScoreMat}
\alias{respFunScoreMat}
\title{Derivative of the Lagrangian of the parametric response function}
\usage{
respFunScoreMat(
  betas,
  X,
  reg,
  thetaMat,
  muMarg,
  psi,
  p,
  v,
  allowMissingness,
  naId,
  ...
)
}
\arguments{
\item{betas}{a vector of length (deg+1)*(p+1) with regression parameters with
deg the degree of the response function and the lagrangian multipliers}

\item{X}{the nxp data matrix}

\item{reg}{a matrix of regressors with the dimension nx(deg+1)}

\item{thetaMat}{The n-by-p matrix with dispersion parameters}

\item{muMarg}{offset matrix of size nxp}

\item{psi}{a scalar, the importance parameter}

\item{p}{an integer, the number of taxa}

\item{v}{an integer, one plus the degree of the response function}

\item{allowMissingness}{A boolean, are missing values present}

\item{naId}{The numeric index of the missing values in X}

\item{...}{further arguments passed on to the jacobian

The parameters are restricted to be normalized, i.e. all squared intercepts,
 first order and second order parameters sum to 1}
}
\value{
The evaluation of the score functions, a vector of length (p+1)*
(deg+1)
}
\description{
Derivative of the Lagrangian of the parametric response function
}
