% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_residualPlot.R
\name{residualPlot}
\alias{residualPlot}
\title{Make residual plots}
\usage{
residualPlot(
  RCM,
  Dim = 1,
  whichTaxa = "response",
  resid = "Deviance",
  numTaxa = 9,
  mfrow = NULL,
  samColour = NULL,
  samShape = NULL,
  legendLabSize = 15,
  legendTitleSize = 16,
  axisLabSize = 14,
  axisTitleSize = 16,
  taxTitle = TRUE,
  h = 0
)
}
\arguments{
\item{RCM}{an RCM object}

\item{Dim}{an integer, which dimension?}

\item{whichTaxa}{a character string or a character vector,
for which taxa to plot the diagnostic plots}

\item{resid}{the type of residuals to use, either 'Deviance' or 'Pearson'}

\item{numTaxa}{an integer, the number of taxa to plot}

\item{mfrow}{passed on to par().
If not supplied will be calculated based on numTaxa}

\item{samColour, samShape}{Vectors or character strings denoting
the sample colour and shape respectively. If character string is provided,
the variables with this name is extracted from the phyloseq object in RCM}

\item{legendLabSize}{size of the legend labels}

\item{legendTitleSize}{size of the legend title}

\item{axisLabSize}{size of the axis labels}

\item{axisTitleSize}{size of the axis title}

\item{taxTitle}{A boolean, should taxon title be printed}

\item{h}{Position of reference line. Set to NA for no line}
}
\value{
Plots a ggplot2-object to output
}
\description{
Make residual plots
}
\details{
If whichTaxa is 'run' or 'response' the taxa with the highest
run statistics or steepest slopes of the response function are plotted,
 numTax indicates the number. If whichTaxa is a character vector,
 these are interpreted as taxon names to plot.
 This function is mainly meant for linear response functions,
 but can be used for others too.
 The runs test statistic from the tseries package is used.
}
\examples{
data(Zeller)
require(phyloseq)
tmpPhy = prune_taxa(taxa_names(Zeller)[1:120],
prune_samples(sample_names(Zeller)[1:75], Zeller))
#Subset for a quick fit
zellerRCMlin = RCM(tmpPhy, k = 2,
covariates = c('BMI','Age','Country','Diagnosis','Gender'),
responseFun = 'linear', round = TRUE, prevCutOff = 0.03)
residualPlot(zellerRCMlin)
}
\seealso{
\code{\link{RCM}}
}
