% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_inertia.R
\name{inertia}
\alias{inertia}
\title{Calculate the log-likelihoods of all possible models}
\usage{
inertia(rcm)
}
\arguments{
\item{rcm}{an object of the RCM class}
}
\value{
A table with inertias, proportion inertia explained
and cumulative proportion of inertia explained.
}
\description{
Calculate the log-likelihoods of all possible models
}
\examples{
data(Zeller)
require(phyloseq)
tmpPhy = prune_taxa(taxa_names(Zeller)[1:100],
prune_samples(sample_names(Zeller)[1:50], Zeller))
zellerRCM = RCM(tmpPhy, round = TRUE)
inertia(zellerRCM)
}
