% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_functions.R
\name{importBed}
\alias{importBed}
\title{importBed}
\usage{
importBed(filePath, sampleN = 0, keepStandardChr = TRUE, debug = TRUE, ...)
}
\arguments{
\item{filePath}{Path to a BED file}

\item{sampleN}{A positive integer value. The number of intervals in the input
BED file are randomly downsampled to include intervals as many as
\code{sampleN}. The input will be downsampled only if this value is larger
than zero and less than the total number of input intervals.}

\item{keepStandardChr}{TRUE/FALSE (default:TRUE). If set to TRUE, will
convert the \code{seqlevelsStyle} to 'UCSC' and apply
\code{keepStandardChromosomes} function to only keep data from the standard
chromosomes}

\item{debug}{TRUE/FALSE (default:TRUE). Set to FALSE to turn off messages}

\item{...}{Other arguments passed to rtracklayer::import.bed function}
}
\value{
A \code{GRanges} object containing the coordinates of the intervals
  from an input BED file
}
\description{
This function uses \code{rtracklayer::import.bed()} function to import BED
files
}
\examples{
input <- system.file("extdata", "testfile.bed", package='RCAS')
importBed(filePath = input, keepStandardChr = TRUE)

}
