% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.image.R
\name{read.image}
\alias{read.image}
\title{Read Images}
\usage{
read.image(
  file,
  filter.metadata = FALSE,
  proprietary.metadata = TRUE,
  normalize = TRUE,
  series,
  resolution,
  subset,
  read.metadata = TRUE
)
}
\arguments{
\item{file}{character, file name}

\item{filter.metadata}{logical, specifies whether ugly metadata (entries with unprintable characters, and extremely large entries) should be discarded from the metadata table}

\item{proprietary.metadata}{logical, should proprietary metadata be populated to OME-XML}

\item{normalize}{logical, should the original image data be mapped to the [0,1] range}

\item{series}{integer vector specifying series to read; if missing all series included in the file are read}

\item{resolution}{integer vector specifying resolution levels to read; if missing all levels read}

\item{subset}{named list specifing image subsetting}

\item{read.metadata}{logical, should image metadata be read}
}
\value{
An \linkS4class{AnnotatedImage} object or an \linkS4class{AnnotatedImageList} object in case of multi-series data.
}
\description{
Read image files using the Bio-Formats library. A list of supported formats can be found on the \href{http://www.openmicroscopy.org/site/support/bio-formats5/supported-formats.html}{Bio-Formats website}.
}
\examples{
require(EBImage)
f = system.file("images", "sample-color.png", package="EBImage")

img = read.image(f)
img
}
\seealso{
\code{\link{read.metadata}} for reading image metadata, \code{\link{read.omexml}} for reading image metadata as OME-XML
}
\author{
Andrzej Oleś <\email{andrzej.oles@gmail.com}>, 2014-2023
}
