% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtle_colData.R
\docType{methods}
\name{qtle-colData}
\alias{qtle-colData}
\alias{colData}
\alias{colData<-}
\alias{colData,QTLExperiment-method}
\alias{colData<-,QTLExperiment,ANY-method}
\alias{colData<-,QTLExperiment,DataFrame-method}
\alias{colData<-,QTLExperiment,NULL-method}
\title{Modify and view the colData of a QTLExperiment}
\usage{
\S4method{colData}{QTLExperiment,DataFrame}(x) <- value

\S4method{colData}{QTLExperiment,NULL}(x) <- value
}
\arguments{
\item{x}{is a \linkS4class{QTLExperiment} object}

\item{value}{is a matrix-like object with number of rows equal 
to the number of columns in \code{x}.}
}
\value{
For \code{colData}, a DFrame is returned. 
For \code{colData<-}, a modified \linkS4class{QTLExperiment} object is returned with the
updated \code{\link{colData}}.
}
\description{
Methods for changing the \code{\link{colData}} of a QTLExperiment.
}
\details{
The \code{state_id} column in the \code{colData} is protected, and operations 
ensure that this column is not removed from the colData.
}
\examples{
qtle <- mockQTLE()
colData(qtle)
dim(colData(qtle))

qtle$batch <- "batch1"
colData(qtle)

# The state_id column is protected
colData(qtle) <- NULL
colData(qtle)

}
\author{
Christina B Azodi, Amelia Dunstone
}
