% Generated by roxygen2 (4.0.0): do not edit by hand
\name{plot_clade}
\alias{plot_clade}
\title{Plot frequency of response for a single clade.}
\usage{
plot_clade(restab, clade, sequence = NULL, from = 0,
  to = max(restab$position), ...)
}
\arguments{
\item{restab}{A \code{data.frame}. The result of a peptide microarray analysis,
as returned by \code{pepStat}'s \code{restab} function.}

\item{clade}{A \code{character}. The clade to plot.}

\item{sequence}{An optional \code{character} or \code{AAString}. The
sequence of the \code{ProteinSequenceTrack} to plot. It should be the
sequence of the reference genome used in the \code{peptideSet} that
generated the \code{restab}.}

\item{from}{A \code{numeric}, the start coordinate of the plot.}

\item{to}{A \code{numeric}, the end coordinate of the plot.}

\item{...}{Aditional arguments to be passed to \code{plotTracks}.}
}
\description{
Plot an axis and the frequency of response of a single selected clade.
}
\examples{
if(require(pepDat)){
  data(restab)
  plot_clade(restab, clade = c("A", "M"))
}
}
\author{
Renan Sauteraud
}
\seealso{
\code{restab}, \code{plot_inter}, \code{\link{plotTracks}}
}

