% Generated by roxygen2 (4.0.0): do not edit by hand
\docType{class}
\name{CladeTrack}
\alias{CladeTrack}
\alias{CladeTrack-class}
\title{CladeTrack}
\usage{
CladeTrack(restab, clade, name = clade, ...)
}
\arguments{
\item{restab}{A \code{data.frame}. The result of a peptide microarray analysis,
as returned by \code{pepStat}'s \code{restab} function.}

\item{clade}{A \code{character}. The clade to plot.}

\item{name}{A \code{character}. The name of the track, used in the title
panel when plotting. By default, the \code{clade} name.}

\item{...}{Additional argument to be passed to \code{DataTrack}. They will be
  treated as display parameters.}
}
\description{
This track can be used to display the result of pepStat analysis for a single
clade. It contains \code{DTrack}.
}
\section{Slots}{

\describe{
\item{\code{clade}}{A \code{character}. The clade to display.}
}}
\examples{
if(require(pepDat)){
  data(restab)
  ct <- CladeTrack(restab, clade = "M", type = "l", legend = TRUE)
  plotTracks(ct)
}
}
\author{
Renan Sauteraud
}
\seealso{
\code{DTrack}
}

