% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{mutantTranscripts}
\alias{mutantTranscripts}
\title{Adds mutant transcript sequences to the ProteoDiscography in the appropriate slot}
\usage{
mutantTranscripts(x)
}
\arguments{
\item{x}{(ProteoDiscography): ProteoDiscography.}
}
\value{
Return all incorporated mutant transcripts (list of DataFrame).
}
\description{
Adds mutant transcript sequences to the ProteoDiscography in the appropriate slot
}
\examples{

# Import example ProteoDiscography (hg19)
data('ProteoDiscographyExample.hg19', package = 'ProteoDisco')
ProteoDiscographyExample.hg19 <- setTxDb(ProteoDiscographyExample.hg19, TxDb.Hsapiens.UCSC.hg19.knownGene::TxDb.Hsapiens.UCSC.hg19.knownGene)
ProteoDiscographyExample.hg19 <- setGenomicSequences(ProteoDiscographyExample.hg19, BSgenome.Hsapiens.UCSC.hg19::BSgenome.Hsapiens.UCSC.hg19)

# Retrieve all generated mutant transcripts.
mutantTranscripts(ProteoDiscographyExample.hg19)

}
