% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_profiles.R
\name{filter_profiles}
\alias{filter_profiles}
\title{Filter a co-elution profile matrix}
\usage{
filter_profiles(profile_matrix, min_points = 1, min_consecutive = 5)
}
\arguments{
\item{profile_matrix}{a numeric matrix of co-elution profiles, with proteins
in rows, or a \code{\linkS4class{MSnSet}} object}

\item{min_points}{filter profiles without at least this many total, 
non-missing points}

\item{min_consecutive}{filter profiles without at least this many 
consecutive, non-missing points}
}
\value{
the filtered profile matrix
}
\description{
Filter a matrix of co-elution/co-fractionation profiles by removing
profiles without a certain number of non-mising or consecutive points.
}
\examples{
data(scott)
nrow(scott)
filtered <- filter_profiles(scott)
nrow(scott)

}
